# MiBa Video Manager

A desktop application for managing and organizing your video files, built with Electron.

## Features

- 📁 Monitor multiple directories for video files
- 🎬 Automatic thumbnail generation
- 📊 Video metadata display (size, creation date, modification date)
- 🔍 Folder-based organization
- 🎥 Built-in video player
- 🔄 Real-time file watching (automatically detects new/removed videos)

## Installation

1. Clone this repository:
```bash
git clone https://github.com/MiBaDK/video-manager.git
cd video-manager
```

2. Install dependencies:
```bash
npm install
```

3. Run the application:
```bash
npm start
```

## Building

To build the application for Windows:
```bash
npm run build
```

The built application will be in the `dist` folder.

## Usage

1. Click the **Settings** button to add directories to monitor
2. The app will automatically scan for video files in the selected directories
3. Browse videos organized by folder structure in the sidebar
4. Click on a video thumbnail to play it
5. Use the **+ Add Videos** button to manually add individual video files

### Live Transcoding for HEVC `.mov`

Some `.mov` files encoded with HEVC require live transcoding to play smoothly. A lightweight Node service is bundled and automatically started by the Electron main process to perform on-demand HLS transcoding with FFmpeg.

When you open a `.mov` file in the viewer, the app requests an HLS stream from the transcoder. If you close the viewer, the transcoding session is cleaned up automatically.

> Need to run the service manually (for debugging or standalone use)?  
> ```bash
> npm run start:transcoder
> ```
> The service listens on `http://127.0.0.1:4455` by default. You can change the port by setting `TRANSCODER_PORT` before launching.

Advanced configuration is available through environment variables:

- `TRANSCODER_BASE_URL` (renderer): override the URL the viewer uses to reach the service.
- `TRANSCODER_PORT`, `TRANSCODER_SESSION_TTL_MS`, `TRANSCODER_HLS_SEGMENT_SECONDS`, `TRANSCODER_X264_PRESET`, `TRANSCODER_X264_CRF`: tune the backend service behaviour.

## YouTube Integration

MiBa Video Manager can upload, update, and remove videos on YouTube once a Google OAuth client is configured.

1. In [Google Cloud Console](https://console.cloud.google.com/), create or select a project and enable **YouTube Data API v3**.  
2. Configure the OAuth consent screen and add the scopes `youtube`, `youtube.upload`, and `youtube.force-ssl`.  
3. Create **Desktop** OAuth credentials, download the JSON, and copy it to `config/google-oauth.json`.  
4. Restart the app and open **Settings → YouTube Integration**. From there you can connect or disconnect your YouTube account.  
5. Once connected, each video card shows its YouTube status and offers actions to upload, update metadata (title/description/visibility), or remove the upload.

### Manual Test Checklist

- Connect and disconnect a YouTube account from the Settings modal.  
- Upload a video and confirm progress appears in the gallery and on the video detail panel.  
- Update metadata (title, description, visibility) for an uploaded video and verify the change on YouTube.  
- Remove an uploaded video from YouTube and confirm the badge in the gallery disappears.  
- Attempt to upload while signed out and confirm the app prompts to authenticate.  
- Exercise an error path (e.g., revoke OAuth credentials in Google Console) to ensure the error banner is displayed in the UI.

## Supported Video Formats

- MP4, AVI, MOV, MKV, WMV, FLV, WEBM, M4V, MPG, MPEG, 3GP

## Requirements

- Node.js
- FFmpeg (for thumbnail generation and live transcoding)

## Analytics (PostHog)

MiBa Video Manager ships with optional analytics powered by the PostHog free tier. To enable it:

1. Follow the credential walkthrough in `docs/analytics/posthog.md`.
2. Export `POSTHOG_PROJECT_API_KEY` (and optionally `POSTHOG_API_HOST` / `POSTHOG_PERSONAL_API_KEY`).
3. Run `npm run setup:posthog` to generate `config/posthog.json` for local development or CI.

Only the project API key is bundled with the desktop app; personal API keys must stay in developer tooling or CI secrets.

## License

ISC

